window.analyzify.initBing = (bingObj, bingProps) => {
  try {
    if (!bingProps || !bingObj || !bingProps.id) return;

    const { id: bing_id, product_id_format } = bingProps;
    let bingInitialized = false;

    window.uetq = window.uetq || [];

    const updateBingConsent = (status, isGranted) => {
      window.uetq.push('consent', status, { ad_storage: isGranted ? 'granted' : 'denied' });
    };

    const initializeAndTrackBingPage = () => {
      if (bingInitialized) return;
      (function(w,d,t,r,u){var f,n,i;w[u]=w[u]||[],f=function(){var o={ti:bing_id.toString(), enableAutoSpaTracking: false};o.q=w[u],w[u]=new UET(o),w[u].push("pageLoad")},n=d.createElement(t),n.src=r,n.async=1,n.onload=n.onreadystatechange=function(){var s=this.readyState;s&&s!=="loaded"&&s!=="complete"||(f(),n.onload=n.onreadystatechange=null)},i=d.getElementsByTagName(t)[0],i.parentNode.insertBefore(n,i)})(window,document,"script","//bat.bing.com/bat.js","uetq");
      window.uetq = window.uetq || [];
      bingInitialized = true;

      switch(bingObj.shopify_template) {
        case 'index':
          window.analyzify.bingHomepage();
          break;
        case 'search':
          window.analyzify.bingSearch(bingObj.getSearchObj);
          break;
        case 'collection':
          window.analyzify.bingViewItemList(bingObj.getCollectionObj);
          break;
        case 'product':
          window.analyzify.bingViewItem(bingObj.getProductObj);
          break;
        case 'cart':
          window.analyzify.bingViewCart(bingObj.detectedCart);
          break;
      }
    };

    const getIdByFormat = (format, { productObj, variantDetails }) => {
      const idMap = {
        'product_id': () => productObj?.product_id?.toString() || productObj?.id?.toString(),
        'variant_id': () => productObj?.variant_id?.toString() || variantDetails?.id?.toString() || productObj?.variants?.[0]?.id?.toString(),
        'product_sku': () => variantDetails?.sku?.toString() || productObj?.sku?.toString(),
        'shopify_item_id': () => {
          const productId = productObj?.product_id?.toString() || productObj?.id?.toString();
          const variantId = productObj?.variant_id?.toString() || variantDetails?.id?.toString() || productObj?.variants?.[0]?.id?.toString();
          return `shopify_${window.analyzify?.feed_region}_${productId}_${variantId}`;
        }
      };
      return (idMap[format] || idMap['product_id'])()?.toString();
    };

    // Page-related events
    // Homepage
    window.analyzify.bingHomepage = () => {
      try {
        window.uetq.push("event", "ecommerce", {
          event_category: "home",
          currency: window.analyzify?.currency,
        });
        analyzify.log('bingHomepage', 'an_bing', 'bingHomepage');
      } catch (e) { console.error('Error in bingHomepage:', e); }
    };

    // Search
    window.analyzify.bingSearch = (searchObj) => {
      try {
        if (!bingProps.events.search || !searchObj) return;
        
        console.log("searchObj", searchObj);

        window.uetq.push("event", "ecommerce", {
          event_category: "search",
          currency: window.analyzify?.currency,
          items: searchObj.products.map(product => {
            const firstVariant = window.analyzify.getFirstVariant(product);
            const variantDetails = window.analyzify.getVariantDetails(
              product?.variants,
              firstVariant?.id,
            );
            if (!variantDetails) return {};
            return {
              id: getIdByFormat(product_id_format, { productObj: product, variantDetails }),
              name: product.title,
              price: variantDetails.price || window.analyzify.formatPrice(product.price, true),
              quantity: 1,
            }
          }),
        });
        analyzify.log('bingSearch', 'an_bing', 'bingSearch');
      } catch (e) { console.error('Error in bingSearch:', e); }
    };

    // View Item List
    window.analyzify.bingViewItemList = (collectionObj) => {
      try {
        if (!bingProps.events.view_item_list || !collectionObj) return;
        
        window.uetq.push("event", "ecommerce", {
          event_category: "view_item_list",
          currency: window.analyzify?.currency,
          items: collectionObj.products.map(product => {
            const firstVariant = window.analyzify.getFirstVariant(product);
            const variantDetails = window.analyzify.getVariantDetails(
              product?.variants,
              firstVariant?.id,
            );
            if (!variantDetails) return {};
            return {
              id: getIdByFormat(product_id_format, { productObj: product, variantDetails }),
              name: product.title,
              price: variantDetails.price || window.analyzify.formatPrice(product.price, true),
              quantity: 1,
            }
          }),
        });
        analyzify.log('bingViewItemList', 'an_bing', 'bingViewItemList');
      } catch (e) { console.error('Error in bingViewItemList:', e); }
    };

    // View Item
    window.analyzify.bingViewItem = (productObj) => {
      try {
        if (!bingProps.events.view_item || !productObj) return;

        const { product, variant } = productObj;
        if (!product) return analyzify.log("Product object is not found", 'an_bing', 'bingViewItem');
        if(!variant) return analyzify.log('Variant object is not found', 'an_bing', 'bingViewItem');

        const variantInput = window.analyzify?.getCurrentVariant()?.id || variant?.id;
        const variantDetails = window.analyzify.getVariantDetails(product?.variants, variantInput);

        window.uetq.push("event", "ecommerce", {
          event_category: "view_item",
          revenue_value: variantDetails?.price,
          currency: window.analyzify?.currency,
          items: [{
            id: getIdByFormat(product_id_format, { productObj: product, variantDetails }),
            quantity: 1,
            price: variantDetails?.price || window.analyzify.formatPrice(product.price, true),
          }],
        });
        analyzify.log('bingViewItem', 'an_bing', 'bingViewItem');
      } catch (e) { console.error('Error in bingViewItem:', e); }
    };

    // View Cart
    window.analyzify.bingViewCart = (cartObj) => {
      try {
        if (!bingProps.events.view_cart || !cartObj) return;
        if (!cartObj?.items?.length) return;
        
        const bingCart = {
          event_category: "view_cart",
          revenue_value: window.analyzify.formatPrice(cartObj.total_price, true),
          currency: cartObj.currency || window.analyzify?.currency,
          items: cartObj.items.map(item => {
            if (!item) return {};
            return {
              id: getIdByFormat(product_id_format, { productObj: item, variantDetails: item }),
              quantity: item?.quantity || 1,
              price: window.analyzify.formatPrice(item?.price, true)
            }
          }),
        };
        window.uetq.push("event", "ecommerce", bingCart);
        analyzify.log('bingViewCart', 'an_bing', 'bingViewCart');
      } catch (e) { console.error('Error in bingViewCart:', e); }
    };

    // Click-related events
    // Add to Cart
    window.analyzify.bingAddtoCart = (productObj, variantId) => {
      try {
        if (!bingProps.events.add_to_cart || !productObj || !variantId) return;
        const { product = productObj } = productObj.product ? productObj : { product: productObj };
        const variantDetails = window.analyzify.getVariantDetails(product?.variants, variantId || productObj.variant?.id);
        if (!variantDetails) return;

        const quantity = analyzify.findQuantity() || 1;
        const price = variantDetails.price || window.analyzify.formatPrice(product?.price, true);

        window.uetq.push("event", "ecommerce", {
          event_category: "add_to_cart",
          revenue_value: price * quantity,
          currency: window.analyzify?.currency,
          items: [{
            id: getIdByFormat(product_id_format, { productObj: product, variantDetails }),
            quantity: quantity,
            price: price,
          }],
        });
      } catch (e) { console.error('Error in bingAddtoCart:', e); }
    };

    // Begin Checkout
    window.analyzify.bingBeginCheckout = (cartObj) => {
      try {
        if (!bingProps.events.begin_checkout || !cartObj?.items?.length) return;
        
        window.uetq.push("event", "ecommerce", {
          event_category: "begin_checkout",
          revenue_value: window.analyzify.formatPrice(cartObj.total_price, true),
          currency: window.analyzify?.currency,
          items: cartObj.items.map(item => {
            if (!item) return {};
            return {
              id: getIdByFormat(product_id_format, { productObj: item, variantDetails: item }),
              quantity: item?.quantity || 1,
              price: window.analyzify.formatPrice(item?.price, true)
            }
          }),
        });
      } catch (e) { console.error('Error in bingBeginCheckout:', e); }
    };

    // Consent Control Logic
    if (window.analyzify.consent_active) {
      window.analyzify.consentManager.queueConsentAction((initialConsent) => {
        const isGranted = initialConsent.ad_storage === 'granted';
        updateBingConsent('default', isGranted);
        if (isGranted) {
          initializeAndTrackBingPage();
        }
      });
    
      window.analyzify.consentManager.onChange((newConsent) => {
        const isGranted = newConsent.ad_storage === 'granted';
        updateBingConsent('update', isGranted);
        if (isGranted) {
          initializeAndTrackBingPage();
        }
      });
    
    } else {
      initializeAndTrackBingPage();
    }

  } catch (error) {
    console.error('Error processing initBing:', error);
  }
};